<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Account extends Model 
{

    protected $table = 'accounts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_ar', 'name_en', 'numeric_system', 'unit', 'tree_id');

    public function tree()
    {
        return $this->belongsTo('App\Models\Tree', 'tree_id');
    }

}